package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.*;
abstract class SymbolicNameMap implements SymbolicNameMapI {
  public SymbolicNameMap() {
    super();
  }
  public Collection get(String l, ClassGraphI G) throws NoSuchClassGraphNodeException {
    ClassGlobSpec glob = get(l);
    if (glob == null)
      return Collections.singleton(G.getNode(l));
    Collection strings = glob.getStrings();
    if (strings == null) return null;
    Collection nodes = new HashSet();
    Iterator i = strings.iterator();
    while (i.hasNext()) {
      nodes.add(G.getNode((String) i.next()));
    }
    return nodes;
  }
  public boolean match(String l, Object cgv) {
    ClassGlobSpec cgNames = get(l);
    return cgNames == null
      ? String.valueOf(cgv).equals(l)
      : cgNames.match(cgv, null);
  }
  public boolean match(String l, String cgl) {
    ClassGlobSpec cgNames = get(l);
    return cgNames == null
      ? cgl.equals(l)
      : cgNames.match(cgl, null);
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).before(this);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).after(this);
  }

  void universal_trv0(UniversalVisitor _v_) {  }

  void __trav_toGraph_PathDirective_trv_bef(__V_PathDirective_toGraph __v0) {  }

  void __trav_toGraph_PathDirective_trv_aft(__V_PathDirective_toGraph __v0) {  }

  void __trav_toGraph_PathDirective_trv(__V_PathDirective_toGraph __v0) {  }

  void __trav_buildDict_NameMap_trv_bef(__V_NameMap_buildDict __v0) {  }

  void __trav_buildDict_NameMap_trv_aft(__V_NameMap_buildDict __v0) {  }

  void __trav_buildDict_NameMap_trv(__V_NameMap_buildDict __v0) {  }

}
