package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.*;
public abstract class StrategyCombination extends Strategy implements StrategyCombinationI, Cloneable {
  protected Strategy first;
  public Strategy get_first() { return first; }
  public void set_first(Strategy new_first) { first = new_first; }
  protected Strategy_Commalist rest;
  public Strategy_Commalist get_rest() { return rest; }
  public void set_rest(Strategy_Commalist new_rest) { rest = new_rest; }
  public StrategyCombination() { super(); }
  public StrategyCombination(Strategy first, Strategy_Commalist rest) {
    super();
    set_first(first);
    set_rest(rest);
  }
  public boolean isStrategyCombination() { return true; }
  public boolean isStrategyIntersection() { return false; }
 Strategy left, right; 
  public StrategyI getLeftStrategy() {
    if (left == null) left = first;
    return left;
  }
  public StrategyI getRightStrategy() {
    if (right == null) {
      Strategy next = rest.first.it;
      if (rest.first.next == null) {
	right = next;
      } else {
	StrategyCombination r = (StrategyCombination) clone();
	r.first = next;
	r.rest = new Strategy_Commalist(rest.first.next);
	r.left = r.right = null;
	right = r;
      }
    }
    return right;
  }
  public Set getSourceNames() {
    return combineNames(((Strategy) getLeftStrategy()).getSourceNames(),
			((Strategy) getRightStrategy()).getSourceNames());
  }
  public Set getTargetNames() {
    return combineNames(((Strategy) getLeftStrategy()).getTargetNames(),
			((Strategy) getRightStrategy()).getTargetNames());
  }
  public abstract Set combineNames(Set l, Set r) ;
  public String toString() {
    return "(" + first + ", " + rest + ")";
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
    ((UniversalVisitor) _v_).before(this);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).after(this);
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).before_first(this, first);
    first.universal_trv0(_v_);
    ((UniversalVisitor) _v_).after_first(this, first);
    ((UniversalVisitor) _v_).before_rest(this, rest);
    rest.universal_trv0(_v_);
    ((UniversalVisitor) _v_).after_rest(this, rest);
    super.universal_trv0(_v_);
  }

  void __trav_attachEnv_Strategy_trv_bef(__V_Strategy_attachEnv __v0) {
    super.__trav_attachEnv_Strategy_trv_bef(__v0);
  }

  void __trav_attachEnv_Strategy_trv_aft(__V_Strategy_attachEnv __v0) {
    super.__trav_attachEnv_Strategy_trv_aft(__v0);
  }

  void __trav_attachEnv_Strategy_trv(__V_Strategy_attachEnv __v0) {
    first.__trav_attachEnv_Strategy_trv(__v0);
    rest.__trav_attachEnv_Strategy_trv(__v0);
  }

  void __trav_toGraph_PathDirective_trv(__V_PathDirective_toGraph __v0) {  }

}
