package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.*;
class NodeSubsetName extends Simple {
	
	
	public void interpretExpression(SelectorL s, ClassGraph c) {
		// get all node subset definitions in the editor window
		Enumeration allDeclarations = s.get_nodesubsetdef_list().elements();
		while(allDeclarations.hasMoreElements()){
			Object currDeclaration = allDeclarations.nextElement();
			//get the current NodeSubsetDef in the iteration
			NodeSubsetDef nsd = (NodeSubsetDef)currDeclaration;
			//if the name of the current NodeSubsetDef is the same
			//as this NodeSubsetName's strategy expression
			//then interpret the expression that belongs to the CurrentNodeSubsetDef
			if(this.get_name().equals(nsd.get_nodesubsetname().get_name())){
				NodeSubsetExpression nse = nsd.get_nodesubsetexpression();
				nse.interpretExpression(s,c);
			}
		}
	}
	
	protected Ident name;
	public Ident get_name() { return name; }
	public void set_name(Ident new_name) { name = new_name; }
	public NodeSubsetName() { super(); }
	public NodeSubsetName(Ident name) {
		super();
		set_name(name);
	}
	public static NodeSubsetName parse(java.io.Reader in) throws ParseException { return new Parser(in)._NodeSubsetName(); }
	public static NodeSubsetName parse(java.io.InputStream in) throws ParseException { return new Parser(in)._NodeSubsetName(); }
	public static NodeSubsetName parse(String s) {
		try { return parse(new java.io.StringReader(s)); }
		catch (ParseException e) {
			throw new RuntimeException(e.toString());
		}
	}
	void universal_trv0_bef(UniversalVisitor _v_) {
		super.universal_trv0_bef(_v_);
		((UniversalVisitor) _v_).before(this);
	}
	
	void universal_trv0_aft(UniversalVisitor _v_) {
		((UniversalVisitor) _v_).after(this);
		super.universal_trv0_aft(_v_);
	}
	
	void universal_trv0(UniversalVisitor _v_) {
		universal_trv0_bef(_v_);
		((UniversalVisitor) _v_).before_name(this, name);
		((UniversalVisitor) _v_).after_name(this, name);
		super.universal_trv0(_v_);
		universal_trv0_aft(_v_);
	}
	
}
