/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.common.tg;

import edu.neu.ccs.demeter.common.tg.AEdge;
import edu.neu.ccs.demeter.common.tg.CEdge;
import edu.neu.ccs.demeter.common.tg.Edge;
import edu.neu.ccs.demeter.common.tg.Edge_List;
import edu.neu.ccs.demeter.common.tg.IEdge;
import edu.neu.ccs.demeter.common.tg.Mark;
import edu.neu.ccs.demeter.common.tg.NameI;
import edu.neu.ccs.demeter.common.tg.Nonempty_Edge_List;
import edu.neu.ccs.demeter.common.tg.Nonempty_Vertex_DList;
import edu.neu.ccs.demeter.common.tg.Nonempty_int_int_Pair_List;
import edu.neu.ccs.demeter.common.tg.TraversalGraph;
import edu.neu.ccs.demeter.common.tg.UniversalVisitor;
import edu.neu.ccs.demeter.common.tg.Vertex;
import edu.neu.ccs.demeter.common.tg.Vertex_DList;
import edu.neu.ccs.demeter.common.tg.int_int_Pair;
import edu.neu.ccs.demeter.common.tg.int_int_Pair_List;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Dictionary;

class PrintVisitor
extends UniversalVisitor {
    protected int indent;
    protected boolean needSpace;
    protected PrintWriter out = new PrintWriter(System.out, true);

    public int get_indent() {
        return this.indent;
    }

    public void set_indent(int new_indent) {
        this.indent = new_indent;
    }

    public boolean get_needSpace() {
        return this.needSpace;
    }

    public void set_needSpace(boolean new_needSpace) {
        this.needSpace = new_needSpace;
    }

    public PrintVisitor() {
    }

    public PrintVisitor(int indent, boolean needSpace) {
        this.set_indent(indent);
        this.set_needSpace(needSpace);
    }

    PrintWriter get_out() {
        return this.out;
    }

    void set_out(PrintWriter new_out) {
        this.out = new_out;
    }

    PrintVisitor(PrintWriter out) {
        this.set_out(out);
    }

    PrintVisitor(PrintStream out) {
        this.set_out(new PrintWriter(out, true));
    }

    public void finish() {
        this.out.flush();
    }

    protected void space() {
        if (this.needSpace) {
            this.out.print(" ");
        }
        this.needSpace = false;
    }

    public void before_name(Vertex source, NameI dest) {
        this.space();
        this.out.print(source.get_name());
        this.needSpace = true;
    }

    public void before_incoming(Vertex source, Edge_List dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
        this.out.print("\t");
        ++this.indent;
        this.needSpace = false;
        this.space();
        this.out.print("incoming:");
        this.needSpace = false;
        this.out.println();
        int i2 = 0;
        while (i2 < this.indent) {
            this.out.print("\t");
            ++i2;
        }
        this.needSpace = false;
        this.out.print("\t");
        ++this.indent;
        this.needSpace = false;
    }

    public void before_outgoing(Vertex source, Edge_List dest) {
        --this.indent;
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
        this.space();
        this.out.print("outgoing:");
        this.needSpace = false;
        this.out.println();
        int i2 = 0;
        while (i2 < this.indent) {
            this.out.print("\t");
            ++i2;
        }
        this.needSpace = false;
        this.out.print("\t");
        ++this.indent;
        this.needSpace = false;
    }

    public void before_intercopyEdges(Vertex source, int_int_Pair_List dest) {
        --this.indent;
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
        this.space();
        this.out.print("intercopy:");
        this.needSpace = false;
        this.out.print(" ");
        this.needSpace = false;
    }

    public void before_mark(Vertex source, Mark dest) {
        this.out.print(" ");
        this.needSpace = false;
        this.space();
        this.out.print("mark:");
        this.needSpace = false;
        this.out.print(" ");
        this.needSpace = false;
    }

    public void after_mark(Vertex source, Mark dest) {
        this.out.print(".");
        this.needSpace = false;
        --this.indent;
    }

    public void before_source(Edge source, Vertex dest) {
        this.space();
        this.out.print("from:");
        this.needSpace = false;
    }

    public void before_dest(Edge source, Vertex dest) {
        this.space();
        this.out.print("to:");
        this.needSpace = false;
    }

    public void after_mark(Edge source, Mark dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void before_name(CEdge source, NameI dest) {
        this.out.print("->");
        this.needSpace = false;
        this.out.print(" ");
        this.needSpace = false;
        this.space();
        this.out.print(source.get_name());
        this.needSpace = true;
    }

    public void before(AEdge host) {
        this.out.print("=>");
        this.needSpace = false;
        this.out.print(" ");
        this.needSpace = false;
    }

    public void before(IEdge host) {
        this.out.print(":>");
        this.needSpace = false;
        this.out.print(" ");
        this.needSpace = false;
    }

    public void before_forw(Mark source, BitSet dest) {
        this.space();
        this.out.print(source.get_forw());
        this.needSpace = true;
    }

    public void before_back(Mark source, BitSet dest) {
        this.space();
        this.out.print(source.get_back());
        this.needSpace = true;
    }

    public void before_both(Mark source, BitSet dest) {
        this.space();
        this.out.print(source.get_both());
        this.needSpace = true;
    }

    public void before_vertices(TraversalGraph source, Dictionary dest) {
        this.space();
        this.out.print(source.get_vertices());
        this.needSpace = true;
    }

    public void before_edges(TraversalGraph source, Dictionary dest) {
        this.space();
        this.out.print(source.get_edges());
        this.needSpace = true;
    }

    public void before_indent(PrintVisitor source, int dest) {
        this.space();
        this.out.print(source.get_indent());
        this.needSpace = true;
    }

    public void before_needSpace(PrintVisitor source, boolean dest) {
        this.space();
        this.out.print(source.get_needSpace());
        this.needSpace = true;
    }

    public void after_first(Vertex_DList source, Nonempty_Vertex_DList dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void before(Edge_List host) {
        this.out.print("{");
        this.needSpace = false;
    }

    public void after(Edge_List host) {
        this.out.print("}");
        this.needSpace = false;
    }

    public void before_x(int_int_Pair source, int dest) {
        this.out.print("<");
        this.needSpace = false;
        this.space();
        this.out.print(source.get_x());
        this.needSpace = true;
    }

    public void before_y(int_int_Pair source, int dest) {
        this.out.print(",");
        this.needSpace = false;
        this.out.print(" ");
        this.needSpace = false;
        this.space();
        this.out.print(source.get_y());
        this.needSpace = true;
    }

    public void after_y(int_int_Pair source, int dest) {
        this.out.print(">");
        this.needSpace = false;
    }

    public void before(int_int_Pair_List host) {
        this.out.print("{");
        this.needSpace = false;
    }

    public void after(int_int_Pair_List host) {
        this.out.print("}");
        this.needSpace = false;
    }

    public void before_next(Nonempty_Vertex_DList source, Nonempty_Vertex_DList dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
        this.out.println();
        int i2 = 0;
        while (i2 < this.indent) {
            this.out.print("\t");
            ++i2;
        }
        this.needSpace = false;
    }

    public void before_next(Nonempty_Edge_List source, Nonempty_Edge_List dest) {
        this.out.print(" ");
        this.needSpace = false;
    }

    public void before_next(Nonempty_int_int_Pair_List source, Nonempty_int_int_Pair_List dest) {
        this.out.print(" ");
        this.needSpace = false;
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        super.universal_trv0_bef(_v_);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        super.universal_trv0_aft(_v_);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        super.universal_trv0(_v_);
        this.universal_trv0_aft(_v_);
    }
}

