/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.common.tg;

import edu.neu.ccs.demeter.Ident;
import edu.neu.ccs.demeter.Line;
import edu.neu.ccs.demeter.Text;
import edu.neu.ccs.demeter.Word;
import edu.neu.ccs.demeter.common.tg.JavaCharStream;
import edu.neu.ccs.demeter.common.tg.ParseException;
import edu.neu.ccs.demeter.common.tg.ParserConstants;
import edu.neu.ccs.demeter.common.tg.ParserTokenManager;
import edu.neu.ccs.demeter.common.tg.Token;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Vector;

public class Parser
implements ParserConstants {
    public ParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[4];
    private final int[] jj_la1_0 = new int[]{98304, 98304, 896, 1920};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static char unescapifyChar(String s) {
        int c = s.charAt(0);
        if (c == 92) {
            switch (s.charAt(1)) {
                case 'n': {
                    c = 10;
                    break;
                }
                case 't': {
                    c = 9;
                    break;
                }
                case 'b': {
                    c = 8;
                    break;
                }
                case 'r': {
                    c = 13;
                    break;
                }
                case 'f': {
                    c = 12;
                    break;
                }
                case '\\': {
                    c = 92;
                    break;
                }
                case '\'': {
                    c = 39;
                    break;
                }
                case '\"': {
                    c = 34;
                    break;
                }
                default: {
                    c = (char)Integer.parseInt(s.substring(1, s.length()), 8);
                }
            }
        }
        return (char)c;
    }

    static String unescapify(String s) {
        char[] str = new char[s.length()];
        int i = 0;
        int o = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                int j = i + 1;
                while (j < s.length() && Character.digit(s.charAt(j), 8) != -1) {
                    ++j;
                }
                c = Parser.unescapifyChar(s.substring(i - 1, j));
                i = j;
            }
            str[o++] = c;
        }
        return String.valueOf(str, 0, o);
    }

    public final boolean _boolean() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token t = this.jj_consume_token(15);
                return true;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                return false;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final char _char() throws ParseException {
        Token t = this.jj_consume_token(12);
        String s = t.image;
        return Parser.unescapifyChar(s.substring(1, s.length() - 1));
    }

    public final byte _byte() throws ParseException {
        int i = this._int();
        return (byte)i;
    }

    public final short _short() throws ParseException {
        int i = this._int();
        return (short)i;
    }

    public final int _int() throws ParseException {
        Number num = this._Number();
        return num.intValue();
    }

    public final long _long() throws ParseException {
        Number num = this._Number();
        return num.longValue();
    }

    public final float _float() throws ParseException {
        Number num = this._Number();
        return num.floatValue();
    }

    public final double _double() throws ParseException {
        Number num = this._Number();
        return num.doubleValue();
    }

    public final Boolean _Boolean() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token t = this.jj_consume_token(15);
                return Boolean.TRUE;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Character _Character() throws ParseException {
        char c = this._char();
        return new Character(c);
    }

    public final Integer _Integer() throws ParseException {
        int i = this._int();
        return new Integer(i);
    }

    public final Long _Long() throws ParseException {
        long l = this._long();
        return new Long(l);
    }

    public final Float _Float() throws ParseException {
        float f = this._float();
        return new Float(f);
    }

    public final Double _Double() throws ParseException {
        double d = this._double();
        return new Double(d);
    }

    public final Number _Number() throws ParseException {
        String s = null;
        int radix = 0;
        Number num = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        Token t = this.jj_consume_token(7);
                        s = t.image;
                        radix = 10;
                        break;
                    }
                    case 8: {
                        Token t = this.jj_consume_token(8);
                        s = t.image.substring(2, t.image.length());
                        radix = 16;
                        break;
                    }
                    case 9: {
                        Token t = this.jj_consume_token(9);
                        s = t.image;
                        radix = 8;
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (s.charAt(s.length() - 1)) {
                    case 'L': 
                    case 'l': {
                        s = s.substring(0, s.length() - 1);
                        num = new Long(new BigInteger(s, radix).longValue());
                        break block0;
                    }
                }
                num = new Integer(new BigInteger(s, radix).intValue());
                break;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                s = t.image;
                switch (s.charAt(s.length() - 1)) {
                    case 'D': 
                    case 'd': {
                        num = Double.valueOf(s.substring(0, s.length() - 1));
                        break block0;
                    }
                    case 'F': 
                    case 'f': {
                        num = Float.valueOf(s.substring(0, s.length() - 1));
                        break block0;
                    }
                }
                num = Float.valueOf(s);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return num;
    }

    public final String _String() throws ParseException {
        Token t = this.jj_consume_token(13);
        String s = t.image;
        return Parser.unescapify(s.substring(1, s.length() - 1));
    }

    public final StringBuffer _StringBuffer() throws ParseException {
        String s = this._String();
        return new StringBuffer(s);
    }

    public final Ident _Ident() throws ParseException {
        Token t = this.jj_consume_token(17);
        return new Ident(t.image);
    }

    public final Text _Text() throws ParseException {
        Token t = this.jj_consume_token(14);
        String s = t.image;
        return new Text(s.substring(2, s.length() - 2));
    }

    public final Line _Line() throws ParseException {
        this.token_source.SwitchTo(1);
        Token t = this.jj_consume_token(20);
        return new Line(t.image);
    }

    public final Word _Word() throws ParseException {
        this.token_source.SwitchTo(2);
        Token t = this.jj_consume_token(25);
        return new Word(t.image);
    }

    public Parser(InputStream stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 4) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 4) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public Parser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 4) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 4) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public Parser(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 4) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 4) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[26];
        int i = 0;
        while (i < 26) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 4) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 26) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, ParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

