/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib;

import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.ConstraintMapI;
import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.IncompatibleClassGraphsException;
import edu.neu.ccs.demeter.aplib.NameMapI;
import edu.neu.ccs.demeter.aplib.StrategyCombinationI;
import edu.neu.ccs.demeter.aplib.StrategyI;
import edu.neu.ccs.demeter.aplib.TraversalException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.TraversalIntersection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class Traversal {
    ClassGraphI classGraph;

    public static String getVersion() {
        return "AP Library version 0.8.6";
    }

    protected Traversal(ClassGraphI cg) {
        this.classGraph = cg;
    }

    public static Traversal compute(StrategyI S, ClassGraphI G) throws TraversalException {
        return Traversal.compute(S, G, null, null);
    }

    public static Traversal compute(StrategyI S, ClassGraphI G, NameMapI N, ConstraintMapI B) throws TraversalException {
        if (S.isSimpleStrategy()) {
            return new TraversalGraph(S.toSimpleStrategy(), G, N, B);
        }
        if (S.isStrategyCombination()) {
            StrategyCombinationI SC = S.toStrategyCombination();
            Traversal left = Traversal.compute(SC.getLeftStrategy(), G, N, B);
            Traversal right = Traversal.compute(SC.getRightStrategy(), G, N, B);
            if (SC.isStrategyIntersection()) {
                return left.intersect(right);
            }
        }
        throw new TraversalException("Unknown strategy type: " + S);
    }

    public Traversal intersect(Traversal t) throws IncompatibleClassGraphsException {
        return new TraversalIntersection(this, t);
    }

    public ClassGraphI getClassGraph() {
        return this.classGraph;
    }

    public abstract List getNodeSets();

    public abstract NodeSet getNodeSet(Object var1);

    public abstract List getStartSet();

    public abstract NodeSet getStartSet(Object var1);

    public abstract List getFinishSet();

    public abstract NodeSet getFinishSet(Object var1);

    public abstract List getEdgeSets();

    public abstract EdgeSet getEdgeSet(String var1);

    public EdgeSet getEdgeSet(EdgeI e) {
        return this.getEdgeSet(Traversal.edgeKey(e));
    }

    public EdgeSet getConstructionEdgeSet(Object u, String l, Object v) {
        return this.getEdgeSet(Traversal.cedgeKey(u, l, v));
    }

    public EdgeSet getAlternationEdgeSet(Object u, Object v) {
        return this.getEdgeSet(Traversal.aedgeKey(u, v));
    }

    public EdgeSet getInheritanceEdgeSet(Object u, Object v) {
        return this.getEdgeSet(Traversal.iedgeKey(u, v));
    }

    public static String edgeKey(EdgeI e) {
        return e == null ? "null" : (e.isConstructionEdge() ? Traversal.cedgeKey(e.getSource(), e.getLabel(), e.getTarget()) : (e.isAlternationEdge() ? Traversal.aedgeKey(e.getSource(), e.getTarget()) : (e.isInheritanceEdge() ? Traversal.iedgeKey(e.getSource(), e.getTarget()) : null)));
    }

    static String cedgeKey(Object u, String l, Object v) {
        return "-> " + u + "," + l + "," + v;
    }

    static String aedgeKey(Object u, Object v) {
        return "=> " + u + "," + v;
    }

    static String iedgeKey(Object u, Object v) {
        return ":> " + u + "," + v;
    }

    public String toCompactString() {
        String s = "";
        s = s + "Start set: " + this.getStartSet() + "\n";
        s = s + "Nodes:\n";
        Iterator it = this.getNodeSets().iterator();
        while (it.hasNext()) {
            s = s + " " + it.next() + "\n";
        }
        s = s + "Edges:\n";
        Iterator it2 = this.getEdgeSets().iterator();
        while (it2.hasNext()) {
            s = s + " " + it2.next() + "\n";
        }
        s = s + "Finish set: " + this.getFinishSet() + "\n";
        return s;
    }

    public abstract class EdgeSet {
        EdgeI edge;

        EdgeSet(EdgeI e) {
            this.edge = e;
        }

        public EdgeI getEdge() {
            return this.edge;
        }

        public boolean sameEdge(EdgeSet s) {
            return this.edge.equals(s.edge);
        }

        public boolean equals(Object x) {
            return x instanceof EdgeSet && this.sameEdge((EdgeSet)x);
        }

        public String toString() {
            return Traversal.edgeKey(this.edge) + ": " + this.indicesToString();
        }

        abstract String indicesToString();

        public abstract NodeSet getTargetNodeSet();
    }

    public abstract class NodeSet {
        Object node;

        NodeSet(Object v) {
            this.node = v;
        }

        public Object getNode() {
            return this.node;
        }

        public boolean sameNode(NodeSet s) {
            return this.node == null || s.node == null || this.node.equals(s.node);
        }

        public boolean equals(Object x) {
            return x instanceof NodeSet && this.sameNode((NodeSet)x);
        }

        public String toString() {
            return this.node + ": " + this.indicesToString();
        }

        abstract String indicesToString();

        public List getOutgoingEdgeSets() {
            return Collections.unmodifiableList(this.getIncidentEdgeSets(true));
        }

        public List getIncomingEdgeSets() {
            return Collections.unmodifiableList(this.getIncidentEdgeSets(false));
        }

        abstract List getIncidentEdgeSets(boolean var1);
    }
}

