import java.util.*;

public class EntryPoint{

    //required objects
    static DataReader reader = null;

    //Dataset constants for toy data
    static final String TOY_DATASET_PATH =
            "/home/rahul/data/src/ml/dataset/toy/ex3.csv";
    static final int TOY_ROW_COUNT = 47;
    static final int TOY_COL_COUNT = 3;
    static final String TOY_DATA_TYPE = "CSV";
    static final int[] TOY_NUMERIC_COL_IDXS =
            {0,1};//started with 0 for convenience
    static final int[] TOY_NOMINAL_COL_IDXS = {};//0 based
    static final int TOY_LABEL_COL_IDX = 2;// 0 based
    //Dataset constants for housing data
    static final String DATASET_PATH =
            "/home/rahul/data/src/ml/dataset/hw2/perceptronData.txt";
    static final int ROW_COUNT = 1000;
    static final int COL_COUNT = 5;
    static final String DATA_TYPE = "TSV";
    static final int[] NUMERIC_COL_IDXS = {0,1,2,3};//started with 0
    static final int[] NOMINAL_COL_IDXS = {};//0 based
    static final int LABEL_COL_IDX = 4;// 0 based

    /*--------------------------------------------------------------------------
      Functions */
    public static void main(String[] args) throws Exception {
        try {
            int dbSelector = 0;
            reader = new DataReader();
            System.out.println("");
            double[][] data = null;
            DataProcessor processor = new DataProcessor();
            if(dbSelector == -1){
                data = reader.readFile(TOY_DATASET_PATH,
                        TOY_DATA_TYPE,
                        TOY_ROW_COUNT,
                        TOY_COL_COUNT);
                Dataset toyData = getToyDataset(data);
                return;
            }
            if(dbSelector == 0 ){
                data = reader.readFile(DATASET_PATH,
                        DATA_TYPE,
                        ROW_COUNT,
                        COL_COUNT);
                Dataset percepData = getPercepDataset(data);
                Perceptron predictor = new Perceptron(percepData);
                predictor.buildClassifier();
                Log.write("");
                Log.write("");
            }
            //main if-else ends here
            //-------------------------------------------------------
            //test statements----------------------------------------
            //Log.writeToFile(data, "train.csv", ",");
            System.out.println("");
            System.out.println("");
        } catch(Exception e){
            System.out.println("Runtime Error occurred: ");
            System.out.println(e);
            throw e;
        }
    }

    private static Dataset getPercepDataset(double[][] data){
        Dataset percep = new Dataset();
        percep.filePath = DATASET_PATH;
        percep.rowCount = ROW_COUNT;
        percep.colCount = COL_COUNT;
        percep.numericColIDXs = NUMERIC_COL_IDXS;
        percep.nominalColIDXs = NOMINAL_COL_IDXS;
        percep.labelColIDx = LABEL_COL_IDX;
        percep.data = data;
        return percep;
    }

    private static Dataset getToyDataset(double[][] data){
        Dataset toy = new Dataset();
        toy.filePath = TOY_DATASET_PATH;
        toy.rowCount = TOY_ROW_COUNT;
        toy.colCount = TOY_COL_COUNT;
        toy.numericColIDXs = TOY_NUMERIC_COL_IDXS;
        toy.nominalColIDXs = TOY_NOMINAL_COL_IDXS;
        toy.labelColIDx = TOY_LABEL_COL_IDX;
        toy.data = data;
        return toy;
    }
}
