import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class DataReader{

    
    // Given a file path, data type and record count
    // returns a 2D float array containting the data
    public double[][] readFile(String fileName, String dataType, 
			       int rowCount, int colCount)
	throws IOException {
	double[][] output = null;
	BufferedReader reader = new BufferedReader(new FileReader(fileName));
	if(dataType == "SSV"){
	    output = tableDataParser(reader, " ", rowCount, colCount);
	} else if(dataType == "CSV"){
	    output = tableDataParser(reader, ",", rowCount, colCount);
	} else if(dataType == "TSV"){
        output = tableDataParser(reader, "\t", rowCount, colCount);
    }else {
	    return new double[0][0];
	}
	Log.write("Dataset read complete.Contains "+output.length+" lines.");
	return output;
    }

    // parses tabular data into 2D double array
    private double[][] tableDataParser(BufferedReader reader, String delimiter,
		      int rowCount, int colCount) throws IOException {
	double[][] output = new double[rowCount][colCount];
	String line = null; int rowCounter = 0;
	while( (line = reader.readLine()) != null){
	    String[] lineData = line.split(delimiter);
	    int colCounter = 0;
	    for(int valCounter = 0; valCounter < lineData.length; valCounter++ ){
		if (lineData[valCounter].isEmpty())
			       continue;
		output[rowCounter][colCounter] = 
		    Double.parseDouble(lineData[valCounter]); 
		colCounter++;
	    }
	    rowCounter++;
	}
	return output;
    }
}
