import string
import math
#from math import log
import numpy as np
from numpy import * 
from numpy.linalg import *

class NNet:
    def __init__(self):
        self.weight_i_to_h = np.array([[np.random.uniform(-1,1) for col in range(3)] for row in range(8)])
        self.weight_h_to_o = np.array([[np.random.uniform(-1,1) for col in range(8)] for row in range(3)])
                    
    def training1(self,input,target,f):
        self.input = input
        self.target = target
        count = 0
        maxloop = 30000
        lr = 5
        diff1 = np.array([0. for i in range(8)])
        diff2 = np.array([0. for i in range(3)])
        while(count < maxloop):
            count += 1
            if (count % 1000 == 0):
                print count
                               
            for t in range(8):
                res = self.output(input[t])
                hid = self.output1(input[t])
                #print >> f, "input", input[t]
                #print >> f, "res",res
                #print >> f, "hid",hid
                for k in range(8):
                    diff1[k] = res[k] * (1 - res[k]) * (target[t,k] - res[k])
                for h in range(3):
                    diff2[h] = hid[h] * (1 - hid[h]) * np.dot(self.weight_h_to_o[h],diff1)
                #print >> f, "diff1",diff1
                #print >> f, "diff2",diff2

                for i in range(8):
                    for h in range(3):
                        self.weight_i_to_h[i,h] += lr * diff2[h] * input[t,i]
                for h in range(3):
                    for k in range(8):
                        self.weight_h_to_o[h,k] += lr * diff1[k] * hid[h] 
                #print >> f,"i to h", self.weight_i_to_h
                #print >> f, "h to o",self.weight_h_to_o
                #print >> f, "-----------------------------------------"
          
    def output1(self,x):
        tem = np.dot(x,self.weight_i_to_h)
        hidden = np.array([1./(1. + math.exp(-tem[i])) for i in range(3)])
        return hidden
    
    def output(self,x):
        tem = np.dot(x,self.weight_i_to_h)
        hidden = np.array([1./(1. + math.exp(-tem[i])) for i in range(3)])
        tem2 = np.dot(hidden,self.weight_h_to_o)
        output = np.array([1./(1. + math.exp(-tem2[i])) for i in range(8)])
        return output

    
    def testing(self,x):
        tem = np.dot(x,self.weight_i_to_h)
        col,row = tem.shape
        hidden = np.array([[1. / (1. + math.exp(-tem[i,j])) for j in range(row)] for i in range(col)])
        #print hidden
        tem2 = np.dot(hidden,self.weight_h_to_o)
        col2,row2 = tem2.shape
        output = np.array([[round(1. / (1. + math.exp(-tem2[i,j])), 3) for j in range(row2)] for i in range(col2)])
        for i in range(8):
            for j in range(8):
                if(output[i,j] < 0.1):
                    output[i,j] = 0
                if(output[i,j] > 0.9):
                    output[i,j] = 1
        return output
    
    

data = np.array([[0.,0.,0.,0.,0.,0.,0.,1.],
                 [0.,0.,0.,0.,0.,0.,1.,0.],
                 [0.,0.,0.,0.,0.,1.,0.,0.],
                 [0.,0.,0.,0.,1.,0.,0.,0.],
                 [0.,0.,0.,1.,0.,0.,0.,0.],
                 [0.,0.,1.,0.,0.,0.,0.,0.],
                 [0.,1.,0.,0.,0.,0.,0.,0.],
                 [1.,0.,0.,0.,0.,0.,0.,0.]])
#print data
#data1 = data[:,1:3]
#print data1.shape
#a = np.array([[np.random.uniform(-0.5,0.5) for col in range(3)] for row in range(8)])
#b = np.array([[np.random.uniform(-0.5,0.5) for col in range(8)] for row in range(3)])
#print a[:,1]
#print data[1]
#t = np.dot(data[1],a)
#print np.dot(t,b)
#a = np.array([0 for i in range(5)])
#print a
#a[0] = 1
#print a


t = NNet()
#print t.testing(data)
f = open("out.txt", "w")
t.training1(data, data,f)
print t.testing(data)
print >>f,"result!!!:", t.testing(data)
f.close()

        
        

