package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.*;
class DisplayVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent; }
  public void set_indent(int new_indent) { indent = new_indent; }
  public DisplayVisitor() { super(); }
  public DisplayVisitor(int indent) {
    super();
    set_indent(indent);
  }

    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    DisplayVisitor(java.io.PrintWriter out)     { set_out(out); }
    DisplayVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush(); }
  public void before(Main host) {
    out.print(": Main  (");
    indent++;
  }
  public void after(Main host) {
    out.print(" )");
    indent--;
  }
  public void before(CollectVisitor host) {
    out.print(": CollectVisitor  (");
    indent++;
  }
  public void after(CollectVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before(XAspectLanguage2 host) {
    out.print(": XAspectLanguage2  (");
    indent++;
  }
  public void after(XAspectLanguage2 host) {
    out.print(" )");
    indent--;
  }
  public void before_aspectlanguage_list(XAspectLanguage2 source, AspectLanguage_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<aspectlanguage_list> ");
  }
  public void before(ClassDictionaryL host) {
    out.print(": ClassDictionaryL  (");
    indent++;
  }
  public void after(ClassDictionaryL host) {
    out.print(" )");
    indent--;
  }
  public void before_classdictionaryname(ClassDictionaryL source, ClassDictionaryName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdictionaryname> ");
  }
  public void before_classdict(ClassDictionaryL source, ClassDict dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdict> ");
  }
  public void before(ClassDictionaryName host) {
    out.print(": ClassDictionaryName  (");
    indent++;
  }
  public void after(ClassDictionaryName host) {
    out.print(" )");
    indent--;
  }
  public void before_ident(ClassDictionaryName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<ident> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_ident() + "\"");
  }
  public void before(TraversalName host) {
    out.print(": TraversalName  (");
    indent++;
  }
  public void after(TraversalName host) {
    out.print(" )");
    indent--;
  }
  public void before_ident(TraversalName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<ident> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_ident() + "\"");
  }
  public void before(SelectorL host) {
    out.print(": SelectorL  (");
    indent++;
  }
  public void after(SelectorL host) {
    out.print(" )");
    indent--;
  }
  public void before_traversalname(SelectorL source, TraversalName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<traversalname> ");
  }
  public void before_strategydef_list(SelectorL source, StrategyDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategydef_list> ");
  }
  public void before_nodesubsetdef_list(SelectorL source, NodeSubsetDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<nodesubsetdef_list> ");
  }
  public void before_selectorname(SelectorL source, SelectorName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<selectorname> ");
  }
  public void before_classdictionaryname(SelectorL source, ClassDictionaryName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdictionaryname> ");
  }
  public void before(StrategyDef host) {
    out.print(": StrategyDef  (");
    indent++;
  }
  public void after(StrategyDef host) {
    out.print(" )");
    indent--;
  }
  public void before_strategyname(StrategyDef source, StrategyName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategyname> ");
  }
  public void before_strategyexpression(StrategyDef source, StrategyExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategyexpression> ");
  }
  public void before(NodeSubsetDef host) {
    out.print(": NodeSubsetDef  (");
    indent++;
  }
  public void after(NodeSubsetDef host) {
    out.print(" )");
    indent--;
  }
  public void before_nodesubsetname(NodeSubsetDef source, NodeSubsetName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<nodesubsetname> ");
  }
  public void before_nodesubsetexpression(NodeSubsetDef source, NodeSubsetExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<nodesubsetexpression> ");
  }
  public void before(SelectorName host) {
    out.print(": SelectorName  (");
    indent++;
  }
  public void after(SelectorName host) {
    out.print(" )");
    indent--;
  }
  public void before_ident(SelectorName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<ident> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_ident() + "\"");
  }
  public void before(ClassDict host) {
    out.print(": ClassDict  (");
    indent++;
  }
  public void after(ClassDict host) {
    out.print(" )");
    indent--;
  }
  public void before_text(ClassDict source, Text dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<text> ");
    out.print(" : Text");
    out.print(" {{" + source.get_text() + "}" + "}" + " ");
  }
  public void before(BCompound host) {
    out.print(": BCompound  (");
    indent++;
  }
  public void after(BCompound host) {
    out.print(" )");
    indent--;
  }
  public void before_op(BCompound source, BinaryOp dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<op> ");
  }
  public void before_args(BCompound source, NodeSubsetExpression_PCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<args> ");
  }
  public void before(UCompound host) {
    out.print(": UCompound  (");
    indent++;
  }
  public void after(UCompound host) {
    out.print(" )");
    indent--;
  }
  public void before_op(UCompound source, UnaryOp dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<op> ");
  }
  public void before_arg(UCompound source, NodeSubsetExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<arg> ");
  }
  public void before(Union host) {
    out.print(": Union  (");
    indent++;
  }
  public void after(Union host) {
    out.print(" )");
    indent--;
  }
  public void before(Intersection host) {
    out.print(": Intersection  (");
    indent++;
  }
  public void after(Intersection host) {
    out.print(" )");
    indent--;
  }
  public void before(Complement host) {
    out.print(": Complement  (");
    indent++;
  }
  public void after(Complement host) {
    out.print(" )");
    indent--;
  }
  public void before(ClassNameSet host) {
    out.print(": ClassNameSet  (");
    indent++;
  }
  public void after(ClassNameSet host) {
    out.print(" )");
    indent--;
  }
  public void before_classname_bclist(ClassNameSet source, ClassName_BCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classname_bclist> ");
  }
  public void before(GraphNodes host) {
    out.print(": GraphNodes  (");
    indent++;
  }
  public void after(GraphNodes host) {
    out.print(" )");
    indent--;
  }
  public void before_strategyname(GraphNodes source, StrategyName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategyname> ");
  }
  public void before(GraphNodeRegExp host) {
    out.print(": GraphNodeRegExp  (");
    indent++;
  }
  public void after(GraphNodeRegExp host) {
    out.print(" )");
    indent--;
  }
  public void before_classname(GraphNodeRegExp source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classname> ");
  }
  public void before_wildcard(GraphNodeRegExp source, WildCard dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<wildcard> ");
  }
  public void before(WildCard host) {
    out.print(": WildCard  (");
    indent++;
  }
  public void after(WildCard host) {
    out.print(" )");
    indent--;
  }
  public void before(StrategyExpression host) {
    out.print(": StrategyExpression  (");
    indent++;
  }
  public void after(StrategyExpression host) {
    out.print(" )");
    indent--;
  }
  public void before_strategy(StrategyExpression source, Strategy dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategy> ");
  }
  public void before_parsedNameMap(SimpleStrategy source, NameMap dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<parsedNameMap> ");
  }
  public void before(StrategyGraph host) {
    out.print(": StrategyGraph  (");
    indent++;
  }
  public void after(StrategyGraph host) {
    out.print(" )");
    indent--;
  }
  public void before_edges(StrategyGraph source, SGEdge_SList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<edges> ");
  }
  public void before(SGEdge host) {
    out.print(": SGEdge  (");
    indent++;
  }
  public void after(SGEdge host) {
    out.print(" )");
    indent--;
  }
  public void before_sourcemarker(SGEdge source, SourceMarker dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<sourcemarker> ");
  }
  public void before_source(SGEdge source, GlobSpec dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<source> ");
  }
  public void before_targetmarker(SGEdge source, TargetMarker dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<targetmarker> ");
  }
  public void before_target(SGEdge source, GlobSpec dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<target> ");
  }
  public void before_constraint(SGEdge source, NegativeConstraint dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<constraint> ");
  }
  public void before(SourceMarker host) {
    out.print(": SourceMarker  (");
    indent++;
  }
  public void after(SourceMarker host) {
    out.print(" )");
    indent--;
  }
  public void before(TargetMarker host) {
    out.print(": TargetMarker  (");
    indent++;
  }
  public void after(TargetMarker host) {
    out.print(" )");
    indent--;
  }
  public void before(PathDirective host) {
    out.print(": PathDirective  (");
    indent++;
  }
  public void after(PathDirective host) {
    out.print(" )");
    indent--;
  }
  public void before_source(PathDirective source, SourceDirective dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<source> ");
  }
  public void before_constraint(PathDirective source, NegativeConstraint dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<constraint> ");
  }
  public void before_segments(PathDirective source, PathSegment_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<segments> ");
  }
  public void before_target(PathDirective source, TargetDirective dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<target> ");
  }
  public void before_sources(SourceDirective source, ClassGlobSpec dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<sources> ");
  }
  public void before(From host) {
    out.print(": From  (");
    indent++;
  }
  public void after(From host) {
    out.print(" )");
    indent--;
  }
  public void before(PathSegment host) {
    out.print(": PathSegment  (");
    indent++;
  }
  public void after(PathSegment host) {
    out.print(" )");
    indent--;
  }
  public void before_node(PathSegment source, PositiveConstraint dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<node> ");
  }
  public void before_constraint(PathSegment source, NegativeConstraint dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<constraint> ");
  }
  public void before_glob(Constraint source, GlobSpec dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<glob> ");
  }
  public void before(Through host) {
    out.print(": Through  (");
    indent++;
  }
  public void after(Through host) {
    out.print(" )");
    indent--;
  }
  public void before(Via host) {
    out.print(": Via  (");
    indent++;
  }
  public void after(Via host) {
    out.print(" )");
    indent--;
  }
  public void before(Bypassing host) {
    out.print(": Bypassing  (");
    indent++;
  }
  public void after(Bypassing host) {
    out.print(" )");
    indent--;
  }
  public void before(OnlyThrough host) {
    out.print(": OnlyThrough  (");
    indent++;
  }
  public void after(OnlyThrough host) {
    out.print(" )");
    indent--;
  }
  public void before_targets(TargetDirective source, ClassGlobSpec dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<targets> ");
  }
  public void before(To host) {
    out.print(": To  (");
    indent++;
  }
  public void after(To host) {
    out.print(" )");
    indent--;
  }
  public void before(ToStop host) {
    out.print(": ToStop  (");
    indent++;
  }
  public void after(ToStop host) {
    out.print(" )");
    indent--;
  }
  public void before_first(StrategyCombination source, Strategy dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before_rest(StrategyCombination source, Strategy_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<rest> ");
  }
  public void before(Join host) {
    out.print(": Join  (");
    indent++;
  }
  public void after(Join host) {
    out.print(" )");
    indent--;
  }
  public void before(Merge host) {
    out.print(": Merge  (");
    indent++;
  }
  public void after(Merge host) {
    out.print(" )");
    indent--;
  }
  public void before(Intersect host) {
    out.print(": Intersect  (");
    indent++;
  }
  public void after(Intersect host) {
    out.print(" )");
    indent--;
  }
  public void before(StrategyReference host) {
    out.print(": StrategyReference  (");
    indent++;
  }
  public void after(StrategyReference host) {
    out.print(" )");
    indent--;
  }
  public void before_ident(StrategyReference source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<ident> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_ident() + "\"");
  }
  public void before(NameMap host) {
    out.print(": NameMap  (");
    indent++;
  }
  public void after(NameMap host) {
    out.print(" )");
    indent--;
  }
  public void before_bindings(NameMap source, NameBinding_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<bindings> ");
  }
  public void before(NameBinding host) {
    out.print(": NameBinding  (");
    indent++;
  }
  public void after(NameBinding host) {
    out.print(" )");
    indent--;
  }
  public void before_sgName(NameBinding source, Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<sgName> ");
  }
  public void before_cgNames(NameBinding source, ClassGlobSpec dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cgNames> ");
  }
  public void before(OneGlob host) {
    out.print(": OneGlob  (");
    indent++;
  }
  public void after(OneGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_glob(OneGlob source, Glob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<glob> ");
  }
  public void before(GlobSet host) {
    out.print(": GlobSet  (");
    indent++;
  }
  public void after(GlobSet host) {
    out.print(" )");
    indent--;
  }
  public void before_globs(GlobSet source, Glob_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<globs> ");
  }
  public void before(ClassGlob host) {
    out.print(": ClassGlob  (");
    indent++;
  }
  public void after(ClassGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_name(ClassGlob source, ClassNameGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before(PartGlob host) {
    out.print(": PartGlob  (");
    indent++;
  }
  public void after(PartGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_source(PartGlob source, SourceGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<source> ");
  }
  public void before_name(PartGlob source, PartNameGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before_target(PartGlob source, TargetGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<target> ");
  }
  public void before(SubclassGlob host) {
    out.print(": SubclassGlob  (");
    indent++;
  }
  public void after(SubclassGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_source(SubclassGlob source, SourceGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<source> ");
  }
  public void before_target(SubclassGlob source, TargetGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<target> ");
  }
  public void before(SuperclassGlob host) {
    out.print(": SuperclassGlob  (");
    indent++;
  }
  public void after(SuperclassGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_source(SuperclassGlob source, SourceGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<source> ");
  }
  public void before_target(SuperclassGlob source, TargetGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<target> ");
  }
  public void before(SourceGlob host) {
    out.print(": SourceGlob  (");
    indent++;
  }
  public void after(SourceGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_name(SourceGlob source, ClassNameGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before(TargetGlob host) {
    out.print(": TargetGlob  (");
    indent++;
  }
  public void after(TargetGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_name(TargetGlob source, ClassNameGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before(ClassNameExact host) {
    out.print(": ClassNameExact  (");
    indent++;
  }
  public void after(ClassNameExact host) {
    out.print(" )");
    indent--;
  }
  public void before_classname(ClassNameExact source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classname> ");
  }
  public void before(AnyClass host) {
    out.print(": AnyClass  (");
    indent++;
  }
  public void after(AnyClass host) {
    out.print(" )");
    indent--;
  }
  public void before(PartNameExact host) {
    out.print(": PartNameExact  (");
    indent++;
  }
  public void after(PartNameExact host) {
    out.print(" )");
    indent--;
  }
  public void before_partname(PartNameExact source, PartName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<partname> ");
  }
  public void before(AnyPart host) {
    out.print(": AnyPart  (");
    indent++;
  }
  public void after(AnyPart host) {
    out.print(" )");
    indent--;
  }
  public void before(OneClassGlob host) {
    out.print(": OneClassGlob  (");
    indent++;
  }
  public void after(OneClassGlob host) {
    out.print(" )");
    indent--;
  }
  public void before_classglob(OneClassGlob source, ClassGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classglob> ");
  }
  public void before(ClassGlobSet host) {
    out.print(": ClassGlobSet  (");
    indent++;
  }
  public void after(ClassGlobSet host) {
    out.print(" )");
    indent--;
  }
  public void before_globs(ClassGlobSet source, ClassGlob_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<globs> ");
  }
  public void before(ClassName host) {
    out.print(": ClassName  (");
    indent++;
  }
  public void after(ClassName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(ClassName source, Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before(PartName host) {
    out.print(": PartName  (");
    indent++;
  }
  public void after(PartName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(PartName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(Name host) {
    out.print(": Name  {");
    indent++;
  }
  public void after(Name host) {
    out.print(" }");
    indent--;
  }
  public void before_first(Name source, Nonempty_Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(StrategyName host) {
    out.print(": StrategyName  (");
    indent++;
  }
  public void after(StrategyName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(StrategyName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(NodeSubsetName host) {
    out.print(": NodeSubsetName  (");
    indent++;
  }
  public void after(NodeSubsetName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(NodeSubsetName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(SymbolicNameMapI host) {
    out.print(": SymbolicNameMapI  (");
    indent++;
  }
  public void after(SymbolicNameMapI host) {
    out.print(" )");
    indent--;
  }
  public void before(PrintVisitor host) {
    out.print(": PrintVisitor  (");
    indent++;
  }
  public void after(PrintVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(PrintVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<needSpace> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(CopyVisitor host) {
    out.print(": CopyVisitor  (");
    indent++;
  }
  public void after(CopyVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_copy(CopyVisitor source, Object dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<copy> ");
  }
  public void before(SubgraphVisitor host) {
    out.print(": SubgraphVisitor  (");
    indent++;
  }
  public void after(SubgraphVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(EqualVisitor host) {
    out.print(": EqualVisitor  (");
    indent++;
  }
  public void after(EqualVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(DisplayVisitor host) {
    out.print(": DisplayVisitor  (");
    indent++;
  }
  public void after(DisplayVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(DisplayVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before(TraceVisitor host) {
    out.print(": TraceVisitor  (");
    indent++;
  }
  public void after(TraceVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(TraceVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before(AspectLanguage_List host) {
    out.print(": AspectLanguage_List  {");
    indent++;
  }
  public void after(AspectLanguage_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(AspectLanguage_List source, Nonempty_AspectLanguage_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(StrategyDef_List host) {
    out.print(": StrategyDef_List  {");
    indent++;
  }
  public void after(StrategyDef_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(StrategyDef_List source, Nonempty_StrategyDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(NodeSubsetDef_List host) {
    out.print(": NodeSubsetDef_List  {");
    indent++;
  }
  public void after(NodeSubsetDef_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(NodeSubsetDef_List source, Nonempty_NodeSubsetDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(NodeSubsetExpression_PCList host) {
    out.print(": NodeSubsetExpression_PCList  {");
    indent++;
  }
  public void after(NodeSubsetExpression_PCList host) {
    out.print(" }");
    indent--;
  }
  public void before_first(NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(ClassName_BCList host) {
    out.print(": ClassName_BCList  {");
    indent++;
  }
  public void after(ClassName_BCList host) {
    out.print(" }");
    indent--;
  }
  public void before_first(ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(SGEdge_SList host) {
    out.print(": SGEdge_SList  {");
    indent++;
  }
  public void after(SGEdge_SList host) {
    out.print(" }");
    indent--;
  }
  public void before_first(SGEdge_SList source, Nonempty_SGEdge_SList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(PathSegment_List host) {
    out.print(": PathSegment_List  {");
    indent++;
  }
  public void after(PathSegment_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(PathSegment_List source, Nonempty_PathSegment_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(Strategy_Commalist host) {
    out.print(": Strategy_Commalist  {");
    indent++;
  }
  public void after(Strategy_Commalist host) {
    out.print(" }");
    indent--;
  }
  public void before_first(Strategy_Commalist source, Nonempty_Strategy_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(NameBinding_Commalist host) {
    out.print(": NameBinding_Commalist  {");
    indent++;
  }
  public void after(NameBinding_Commalist host) {
    out.print(" }");
    indent--;
  }
  public void before_first(NameBinding_Commalist source, Nonempty_NameBinding_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(Glob_Commalist host) {
    out.print(": Glob_Commalist  {");
    indent++;
  }
  public void after(Glob_Commalist host) {
    out.print(" }");
    indent--;
  }
  public void before_first(Glob_Commalist source, Nonempty_Glob_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(ClassGlob_Commalist host) {
    out.print(": ClassGlob_Commalist  {");
    indent++;
  }
  public void after(ClassGlob_Commalist host) {
    out.print(" }");
    indent--;
  }
  public void before_first(ClassGlob_Commalist source, Nonempty_ClassGlob_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(Nonempty_Name host) {
    out.print(": Nonempty_Name  (");
    indent++;
  }
  public void after(Nonempty_Name host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_Name source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_it() + "\"");
  }
  public void before_next(Nonempty_Name source, Nonempty_Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_AspectLanguage_List host) {
    out.print(": Nonempty_AspectLanguage_List  (");
    indent++;
  }
  public void after(Nonempty_AspectLanguage_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_AspectLanguage_List source, AspectLanguage dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_AspectLanguage_List source, Nonempty_AspectLanguage_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_StrategyDef_List host) {
    out.print(": Nonempty_StrategyDef_List  (");
    indent++;
  }
  public void after(Nonempty_StrategyDef_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_StrategyDef_List source, StrategyDef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_StrategyDef_List source, Nonempty_StrategyDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_NodeSubsetDef_List host) {
    out.print(": Nonempty_NodeSubsetDef_List  (");
    indent++;
  }
  public void after(Nonempty_NodeSubsetDef_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_NodeSubsetDef_List source, NodeSubsetDef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_NodeSubsetDef_List source, Nonempty_NodeSubsetDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_NodeSubsetExpression_PCList host) {
    out.print(": Nonempty_NodeSubsetExpression_PCList  (");
    indent++;
  }
  public void after(Nonempty_NodeSubsetExpression_PCList host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_NodeSubsetExpression_PCList source, NodeSubsetExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_ClassName_BCList host) {
    out.print(": Nonempty_ClassName_BCList  (");
    indent++;
  }
  public void after(Nonempty_ClassName_BCList host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_ClassName_BCList source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_SGEdge_SList host) {
    out.print(": Nonempty_SGEdge_SList  (");
    indent++;
  }
  public void after(Nonempty_SGEdge_SList host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_SGEdge_SList source, SGEdge dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_SGEdge_SList source, Nonempty_SGEdge_SList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_PathSegment_List host) {
    out.print(": Nonempty_PathSegment_List  (");
    indent++;
  }
  public void after(Nonempty_PathSegment_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_PathSegment_List source, PathSegment dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_PathSegment_List source, Nonempty_PathSegment_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_Strategy_Commalist host) {
    out.print(": Nonempty_Strategy_Commalist  (");
    indent++;
  }
  public void after(Nonempty_Strategy_Commalist host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_Strategy_Commalist source, Strategy dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_Strategy_Commalist source, Nonempty_Strategy_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_NameBinding_Commalist host) {
    out.print(": Nonempty_NameBinding_Commalist  (");
    indent++;
  }
  public void after(Nonempty_NameBinding_Commalist host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_NameBinding_Commalist source, NameBinding dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_NameBinding_Commalist source, Nonempty_NameBinding_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_Glob_Commalist host) {
    out.print(": Nonempty_Glob_Commalist  (");
    indent++;
  }
  public void after(Nonempty_Glob_Commalist host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_Glob_Commalist source, Glob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_Glob_Commalist source, Nonempty_Glob_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_ClassGlob_Commalist host) {
    out.print(": Nonempty_ClassGlob_Commalist  (");
    indent++;
  }
  public void after(Nonempty_ClassGlob_Commalist host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_ClassGlob_Commalist source, ClassGlob dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_ClassGlob_Commalist source, Nonempty_ClassGlob_Commalist dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
