package CSU670_Plugin.editors;

import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

import edu.neu.ccs.demeter.aplib.EdgeI;

import CSU670_Plugin.actions.AspectXSyntaxHighlight;
import CSU670_Plugin.gen.Main;

public class AspectXEditor extends TextEditor {

	public static AspectXEditor current=null;
	public static int editorCount=0;
	
	//private ColorManager colorManager;

	public AspectXEditor() {
		super();
		current=this;
		editorCount++;
		setDocumentProvider(new TextFileDocumentProvider());
	}
	public void dispose() {
		if(current==this) current=null;
		editorCount--;
		super.dispose();
	}
	//get full text contents of this
	public String getText(){
		return getDocument().get();
	}
	public IDocument getDocument(){
		return getDocumentProvider().getDocument(getEditorInput());
	}
	
	public String getCursorPosition(){ return super.getCursorPosition(); }
	
	public void highlight(Color c,int start,int len){
		getSourceViewer().setTextColor(c,start,len,false);
	}
	public void highlight(Color c,IRegion r){
		highlight(c,r.getOffset(),r.getLength());
	}
	public void unhighlight(){
		highlight(AspectXSyntaxHighlight.black,0,getDocument().getLength());
	}
	public String currentStrategy() throws Exception{
		FindReplaceDocumentAdapter f = 
			new FindReplaceDocumentAdapter(getDocument());
		IRegion region;
		String strategy;
		
		String[]  p = AspectXEditor.current.getCursorPosition().split(":");
		int col = Integer.parseInt(p[0].trim())-1;
		int row = Integer.parseInt(p[1].trim())-1;
		//cursor position
		int pos = getDocument().getLineOffset(col)+row;
		
		//rewind to last declare
		region = f.find(pos,"declare",false,false,true,false);
		
		if(region==null) return "";
		
		//find strategy
		region = f.find(region.getOffset(),"declare[^:;]+:[^:;]+:[^;]+;",true,false,false,true);
		
		if(region==null) return "";
		
		if(region.getOffset()>pos || region.getOffset()+region.getLength()<pos)
			return "";
		
		AspectXEditor.current.highlight(AspectXSyntaxHighlight.magenta,region);
		
		strategy = f.subSequence(region.getOffset(),region.getOffset()+region.getLength()).toString();
		strategy = strategy.substring(strategy.indexOf(":")+1);
		strategy = strategy.substring(0,strategy.indexOf(":"));
		return strategy.trim();
	}
	public void handleCursorPositionChanged(){
		if(!Main.hadERROR){
			unhighlight();
			AspectXSyntaxHighlight.instance.highlightKeywords();
			AspectXSyntaxHighlight.instance.run(null);
		}
	}
	public void highlightNode(Color c, String s) throws BadLocationException {
		FindReplaceDocumentAdapter f = 
			new FindReplaceDocumentAdapter(getDocument());
		IRegion region;
		
		region = f.find(0,"{{",true,false,false,false);
		region = f.find(region.getOffset(),"\\b"+s+"[^=a-zA-Z]*=",true,true,false,true);
		
		highlight(c,region.getOffset(),s.length());
	}
	public void highlightEdge(Color c, EdgeI e) throws BadLocationException {
		FindReplaceDocumentAdapter f = 
			new FindReplaceDocumentAdapter(getDocument());
		IRegion region1,region2;
		
		region1 = f.find(0,"{{",true,false,false,false);
		region1 = f.find(region1.getOffset(),"\\b"+e.getSource()+"[^=a-zA-Z]*=[^;]+;",true,true,false,true);
	
		region2 = f.find(region1.getOffset(),
				"<\\s*"+e.getLabel()+"\\s*>\\s*"+e.getTarget()+"\\b",true,true,false,true);
		if(region2==null)
		region2 = f.find(region1.getOffset(),e.getTarget().toString(),true,true,true,false);
		
		if(region2==null) return;
		
		if(region2.getOffset()> region1.getOffset()+region1.getLength()) return;
		
		highlight(c,region2);
			
	}
	protected void updateContentDependentActions(){
		super.updateContentDependentActions();
		Main.hadERROR=true;
		Main.userCg=null;
		unhighlight();
		AspectXSyntaxHighlight.instance.highlightKeywords();
	}
}
