package aspectEditor.aspectEditorUtils;
import java.util.Enumeration;
import java.util.HashSet;

import aspectEditor.editors.AspectEditor;
import edu.neu.ccs.demeter.aplib.TraversalException;
class GraphNodes extends Simple {
	
	public void interpretExpression(SelectorL s, edu.neu.ccs.demeter.aplib.cd.ClassGraph cg){
		
		//get all strategy definitions in this SelectorL
		Enumeration allDeclarations = s.get_strategydef_list().elements();
		edu.neu.ccs.demeter.dj.Strategy strat = null;
		
		//loop through them and see if any of their strategy names match that of this GraphNode Declaration
		while(allDeclarations.hasMoreElements()){
			
			Object currDeclaration = allDeclarations.nextElement();
			StrategyDef sd = (StrategyDef)currDeclaration;
			//If you find a strategy def that matches the Graph Node Declaration
			//use its strategy to perform the traversal
			if(this.strategyname.get_name().equals(sd.get_strategyname().get_name())){
				strat= new edu.neu.ccs.demeter.dj.Strategy(sd.get_strategyexpression().get_strategy().toString());
			}
		}
		//use the strategy you got from the previous while loop
		//and construct a traversal object
		edu.neu.ccs.demeter.aplib.TraversalGraph trav=null;
		try {
			trav = new edu.neu.ccs.demeter.aplib.TraversalGraph(strat.toSimpleStrategy(),cg.normalize());
		}
		catch(TraversalException e){
			AspectEditor.traversalViewer.setText(e.getMessage());
		}
		
		//get the nodes and edges traversed and add them to Main's list
		//later they will be used by a highlight function, so the result is shown
		//in the display window
		this.nodesTraversed.addAll(trav.getNodeSets());
		this.edgesTraversed.addAll(trav.getEdgeSets());
		
		Main.nodesTraversed.addAll(trav.getNodeSets());
		Main.edgesTraversed.addAll(trav.getEdgeSets());
	}
	
	protected StrategyName strategyname;
	public StrategyName get_strategyname() { return strategyname; }
	public void set_strategyname(StrategyName new_strategyname) { strategyname = new_strategyname; }
	public GraphNodes() { super(); }
	public GraphNodes(StrategyName strategyname) {
		super();
		set_strategyname(strategyname);
	}
	public static GraphNodes parse(java.io.Reader in) throws ParseException { return new Parser(in)._GraphNodes(); }
	public static GraphNodes parse(java.io.InputStream in) throws ParseException { return new Parser(in)._GraphNodes(); }
	public static GraphNodes parse(String s) {
		try { return parse(new java.io.StringReader(s)); }
		catch (ParseException e) {
			throw new RuntimeException(e.toString());
		}
	}
	void universal_trv0_bef(UniversalVisitor _v_) {
		super.universal_trv0_bef(_v_);
		((UniversalVisitor) _v_).before(this);
	}
	
	void universal_trv0_aft(UniversalVisitor _v_) {
		((UniversalVisitor) _v_).after(this);
		super.universal_trv0_aft(_v_);
	}
	
	void universal_trv0(UniversalVisitor _v_) {
		universal_trv0_bef(_v_);
		((UniversalVisitor) _v_).before_strategyname(this, strategyname);
		strategyname.universal_trv0(_v_);
		((UniversalVisitor) _v_).after_strategyname(this, strategyname);
		super.universal_trv0(_v_);
		universal_trv0_aft(_v_);
	}
	
}
