/*
 * Decompiled with CFR 0.152.
 */
package aspectEditor.aspectEditorUtils;

import aspectEditor.aspectEditorUtils.ClassName;
import aspectEditor.aspectEditorUtils.Main;
import aspectEditor.aspectEditorUtils.ParseException;
import aspectEditor.aspectEditorUtils.Parser;
import aspectEditor.aspectEditorUtils.SelectorL;
import aspectEditor.aspectEditorUtils.Simple;
import aspectEditor.aspectEditorUtils.UniversalVisitor;
import aspectEditor.aspectEditorUtils.WildCard;
import aspectEditor.editors.AspectEditor;
import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.TraversalException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.dj.Strategy;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;

class GraphNodeRegExp
extends Simple {
    protected ClassName classname;
    protected WildCard wildcard;

    public void interpretExpression(SelectorL s, ClassGraph c) {
        Strategy strat = new Strategy("from * to *");
        HashSet nodesTraversed = new HashSet();
        HashSet<TraversalGraph.NodeSet> nodesToHighlight = new HashSet<TraversalGraph.NodeSet>();
        try {
            TraversalGraph trav = new TraversalGraph(strat.toSimpleStrategy(), (ClassGraphI)c.normalize());
            nodesTraversed = new HashSet(trav.getNodeSets());
        }
        catch (TraversalException e) {
            AspectEditor.traversalViewer.setText(e.getMessage());
        }
        Iterator i = nodesTraversed.iterator();
        while (i.hasNext()) {
            TraversalGraph.NodeSet currNodeset = (TraversalGraph.NodeSet)i.next();
            String currNodeSetName = currNodeset.getNode().toString();
            if (!this.get_classname().toString().startsWith(currNodeSetName)) continue;
            nodesToHighlight.add(currNodeset);
        }
        new HashSet();
        Main.highlightStrategiesBinary(c, nodesToHighlight, null);
    }

    public ClassName get_classname() {
        return this.classname;
    }

    public void set_classname(ClassName new_classname) {
        this.classname = new_classname;
    }

    public WildCard get_wildcard() {
        return this.wildcard;
    }

    public void set_wildcard(WildCard new_wildcard) {
        this.wildcard = new_wildcard;
    }

    public GraphNodeRegExp() {
    }

    public GraphNodeRegExp(ClassName classname, WildCard wildcard) {
        this.set_classname(classname);
        this.set_wildcard(wildcard);
    }

    public static GraphNodeRegExp parse(Reader in) throws ParseException {
        return new Parser(in)._GraphNodeRegExp();
    }

    public static GraphNodeRegExp parse(InputStream in) throws ParseException {
        return new Parser(in)._GraphNodeRegExp();
    }

    public static GraphNodeRegExp parse(String s) {
        try {
            return GraphNodeRegExp.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        super.universal_trv0_bef(_v_);
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
        super.universal_trv0_aft(_v_);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_classname(this, this.classname);
        this.classname.universal_trv0(_v_);
        _v_.after_classname(this, this.classname);
        _v_.before_wildcard(this, this.wildcard);
        this.wildcard.universal_trv0(_v_);
        _v_.after_wildcard(this, this.wildcard);
        super.universal_trv0(_v_);
        this.universal_trv0_aft(_v_);
    }
}

