/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib;

import edu.neu.ccs.demeter.aplib.Traversal;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.aplib.sg.Strategy;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;

public class APLibTest {
    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: java edu.neu.ccs.demeter.aplib.APLibTest class-dictionary-file strategy-file [debug]");
            return;
        }
        System.out.println(TraversalGraph.getVersion());
        try {
            BufferedReader cdin = new BufferedReader(new FileReader(args[0]));
            BufferedReader sgin = new BufferedReader(new FileReader(args[1]));
            TraversalGraph.debug = args.length == 3;
            ClassGraph cg = ClassGraph.readFrom(cdin);
            System.out.println("Expanded class graph:");
            System.out.println(cg);
            Strategy s = Strategy.readFrom(sgin);
            System.out.println("Expanded strategy graph:");
            System.out.println(s);
            long start = System.currentTimeMillis();
            Traversal t = Traversal.compute(s, cg);
            long finish = System.currentTimeMillis();
            System.out.println("Traversal: (" + (finish - start) + "ms)");
            System.out.println(t);
            System.out.println("Traversal subgraph:");
            cg.printTraversalEdges(t, new PrintWriter(System.out, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return;
        }
    }
}

