/*
 * Decompiled with CFR 0.152.
 */
package aspectEditor.editors;

import aspectEditor.aspectEditorUtils.Main;
import aspectEditor.editors.AspectConfiguration;
import aspectEditor.editors.AspectDocumentProvider;
import aspectEditor.editors.ColorManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AspectEditor
extends TextEditor {
    private ColorManager colorManager = new ColorManager();
    public static IDocument myDoc;
    public static StyledText traversalViewer;
    public static boolean buttonPressed;

    static {
        traversalViewer = null;
        buttonPressed = false;
    }

    public AspectEditor() {
        this.setSourceViewerConfiguration(new AspectConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new AspectDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        traversalViewer = new StyledText(parent, 1);
        traversalViewer.setEditable(false);
    }

    public void handleCursorPositionChanged() {
        if (buttonPressed) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            FindReplaceDocumentAdapter f = new FindReplaceDocumentAdapter(doc);
            String cursorPos = this.getCursorPosition();
            String[] lineAndCol = cursorPos.split(" :");
            String lineString = lineAndCol[0];
            int line = Integer.parseInt(lineString);
            try {
                int beginningLineOffset = doc.getLineOffset(line);
                Region toEnd = (Region)f.find(beginningLineOffset - 3, ";", true, false, false, false);
                int semiColonOffset = toEnd.getOffset();
                Region wholeStatement = (Region)f.find(semiColonOffset, "declare", false, false, true, false);
                int declareStatementOffset = wholeStatement.getOffset();
                int length = semiColonOffset - declareStatementOffset;
                Main.highlight(doc.get(declareStatementOffset, length + 1));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

