/*
 * Decompiled with CFR 0.152.
 */
package aspectEditor.aspectEditorUtils;

import aspectEditor.aspectEditorUtils.ClassDictionaryL;
import aspectEditor.aspectEditorUtils.ClassDictionaryName;
import aspectEditor.aspectEditorUtils.NodeSubsetDef;
import aspectEditor.aspectEditorUtils.NodeSubsetExpression;
import aspectEditor.aspectEditorUtils.NodeSubsetName;
import aspectEditor.aspectEditorUtils.ParseException;
import aspectEditor.aspectEditorUtils.Parser;
import aspectEditor.aspectEditorUtils.SelectorL;
import aspectEditor.aspectEditorUtils.SelectorName;
import aspectEditor.aspectEditorUtils.StrategyDef;
import aspectEditor.aspectEditorUtils.StrategyName;
import aspectEditor.aspectEditorUtils.UniversalVisitor;
import aspectEditor.aspectEditorUtils.XAspectLanguage2;
import aspectEditor.editors.AspectEditor;
import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.TraversalException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.dj.ClassGraph;
import edu.neu.ccs.demeter.dj.Strategy;
import edu.neu.ccs.demeter.dj.Visitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Main {
    public static HashSet nodesTraversed = new HashSet();
    public static HashSet edgesTraversed = new HashSet();

    public static Main parse(Reader in) throws ParseException {
        return new Parser(in)._Main();
    }

    public static Main parse(InputStream in) throws ParseException {
        return new Parser(in)._Main();
    }

    public static Main parse(String s) {
        try {
            return Main.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void main(String[] args) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            XAspectLanguage2 s = XAspectLanguage2.parse(in);
            Main.checkSemantics(s);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void highlight(String strategy) {
        String docToParse = AspectEditor.myDoc.get();
        XAspectLanguage2 s = new XAspectLanguage2();
        s = XAspectLanguage2.parse(docToParse);
        HashSet myCDNodeHash = new HashSet();
        Enumeration aspectEnumeration = s.get_aspectlanguage_list().elements();
        String myClass = "";
        String cdType = "aspectEditor.aspectEditorUtils.ClassDictionaryL";
        String traversalType = "aspectEditor.aspectEditorUtils.SelectorL";
        edu.neu.ccs.demeter.aplib.cd.ClassGraph genericCG = new edu.neu.ccs.demeter.aplib.cd.ClassGraph();
        SelectorL mySelector = new SelectorL();
        while (aspectEnumeration.hasMoreElements()) {
            Object currObj = aspectEnumeration.nextElement();
            if (cdType.equals(currObj.getClass().getName())) {
                ClassDictionaryL currDict = (ClassDictionaryL)currObj;
                myClass = currDict.get_classdict().get_text().toString();
                genericCG = edu.neu.ccs.demeter.aplib.cd.ClassGraph.parse((String)myClass);
                myCDNodeHash.addAll(genericCG.getNodes());
            }
            if (!traversalType.equals(currObj.getClass().getName())) continue;
            mySelector = (SelectorL)currObj;
        }
        try {
            StrategyDef sd = StrategyDef.parse(strategy);
            edu.neu.ccs.demeter.aplib.cd.ClassGraph cg = edu.neu.ccs.demeter.aplib.cd.ClassGraph.parse((String)myClass);
            Strategy sg = new Strategy(sd.get_strategyexpression().get_strategy().toString());
            Main.highlightStrategies(cg, sg);
        }
        catch (RuntimeException runtimeException) {
            try {
                NodeSubsetDef ns = NodeSubsetDef.parse(strategy);
                edu.neu.ccs.demeter.aplib.cd.ClassGraph cg = edu.neu.ccs.demeter.aplib.cd.ClassGraph.parse((String)myClass);
                Main.highlightNodeSets(ns, cg, mySelector);
            }
            catch (RuntimeException re2) {
                re2.printStackTrace();
            }
        }
    }

    public static void highlightNodeSets(NodeSubsetDef ns, edu.neu.ccs.demeter.aplib.cd.ClassGraph c, SelectorL s) {
        nodesTraversed = new HashSet();
        edgesTraversed = new HashSet();
        NodeSubsetExpression nse = ns.get_nodesubsetexpression();
        nse.interpretExpression(s, c);
        Main.highlightStrategiesBinary(c, nodesTraversed, edgesTraversed);
    }

    public static void highlightStrategies(edu.neu.ccs.demeter.aplib.cd.ClassGraph cg, Strategy sg) {
        Display display;
        Shell shell;
        StyleRange styleRange;
        TraversalGraph trav;
        cg = cg.normalize();
        AspectEditor.traversalViewer.setText(cg.normalize().toString());
        try {
            trav = new TraversalGraph(sg.toSimpleStrategy(), (ClassGraphI)cg);
            HashSet nodesTraversed = new HashSet(trav.getNodeSets());
            Iterator i = nodesTraversed.iterator();
            while (i.hasNext()) {
                TraversalGraph.NodeSet ns = (TraversalGraph.NodeSet)i.next();
                styleRange = new StyleRange();
                new StyleRange();
                styleRange.start = AspectEditor.traversalViewer.getText().indexOf(ns.getNode().toString());
                styleRange.length = ns.getNode().toString().length();
                shell = new Shell();
                display = shell.getDisplay();
                styleRange.foreground = display.getSystemColor(3);
                AspectEditor.traversalViewer.setStyleRange(styleRange);
                styleRange.start = AspectEditor.traversalViewer.getText().indexOf(String.valueOf(ns.getNode().toString()) + " =");
                styleRange.length = ns.getNode().toString().length();
                styleRange.foreground = display.getSystemColor(3);
                AspectEditor.traversalViewer.setStyleRange(styleRange);
            }
        }
        catch (TraversalException e) {
            AspectEditor.traversalViewer.setText(e.getMessage());
        }
        try {
            trav = new TraversalGraph(sg.toSimpleStrategy(), (ClassGraphI)cg);
            HashSet edgesTraversed = new HashSet(trav.getEdgeSets());
            Iterator i2 = edgesTraversed.iterator();
            while (i2.hasNext()) {
                TraversalGraph.EdgeSet es = (TraversalGraph.EdgeSet)i2.next();
                styleRange = new StyleRange();
                styleRange.start = AspectEditor.traversalViewer.getText().indexOf(es.getEdge().toString());
                styleRange.length = es.getEdge().toString().length();
                shell = new Shell();
                display = shell.getDisplay();
                styleRange.foreground = display.getSystemColor(3);
                AspectEditor.traversalViewer.setStyleRange(styleRange);
            }
        }
        catch (TraversalException e) {
            AspectEditor.traversalViewer.setText(e.getMessage());
        }
    }

    public static void highlightStrategiesBinary(edu.neu.ccs.demeter.aplib.cd.ClassGraph cg, HashSet nodesTraversed, HashSet edgesTraversed) {
        AspectEditor.traversalViewer.setText(cg.normalize().toString());
        String nodes = "";
        Iterator i = nodesTraversed.iterator();
        while (i.hasNext()) {
            TraversalGraph.NodeSet ns = (TraversalGraph.NodeSet)i.next();
            StyleRange styleRange = new StyleRange();
            styleRange.start = AspectEditor.traversalViewer.getText().indexOf(ns.getNode().toString());
            styleRange.length = ns.getNode().toString().length();
            Shell shell = new Shell();
            Display display = shell.getDisplay();
            styleRange.foreground = display.getSystemColor(3);
            AspectEditor.traversalViewer.setStyleRange(styleRange);
            nodes = String.valueOf(nodes) + "\n" + ns.getNode().toString();
            styleRange.start = AspectEditor.traversalViewer.getText().indexOf(String.valueOf(ns.getNode().toString()) + " =");
            styleRange.length = ns.getNode().toString().length();
            styleRange.foreground = display.getSystemColor(3);
            AspectEditor.traversalViewer.setStyleRange(styleRange);
        }
        Iterator i2 = edgesTraversed.iterator();
        while (i2.hasNext()) {
            TraversalGraph.EdgeSet es = (TraversalGraph.EdgeSet)i2.next();
            StyleRange styleRange = new StyleRange();
            styleRange = new StyleRange();
            styleRange.start = AspectEditor.traversalViewer.getText().indexOf(es.getEdge().toString());
            styleRange.length = es.getEdge().toString().length();
            Shell shell = new Shell();
            Display display = shell.getDisplay();
            styleRange.foreground = display.getSystemColor(3);
            AspectEditor.traversalViewer.setStyleRange(styleRange);
            nodes = String.valueOf(nodes) + "\n" + es.getEdge().toString();
        }
    }

    public static void checkSemantics(XAspectLanguage2 s) {
        String stringOfErrors = "Starting Semantic Checker...\n";
        ClassGraph cg = new ClassGraph(true, false);
        try {
            String classpath = System.getProperty("java.class.path");
            String[] classpaths = classpath.split(File.pathSeparator);
            int last_slash = classpaths[0].lastIndexOf("\\");
            String sg_path = String.valueOf(classpaths[0].substring(0, last_slash)) + "\\plugins\\aspectEditor_1.0.0\\aspectElements.jar";
            JarFile jf = new JarFile(new File(sg_path));
            Enumeration<JarEntry> enu = jf.entries();
            while (enu.hasMoreElements()) {
                String entry = ((Object)enu.nextElement()).toString();
                if (entry.indexOf("class") == -1) continue;
                entry = entry.replace('/', '.');
                int last_dot = entry.lastIndexOf(".class");
                entry = entry.substring(0, last_dot);
                Class<?> cl = Class.forName(entry);
                cg.addClass(cl);
            }
        }
        catch (Exception e1) {
            System.out.println("Error opening file aspectElements.jar using the Windows method:");
            System.out.println("\t" + e1 + "\n");
            System.out.println("Will try the MAC/Solaris/LINUX method");
            try {
                String classpath = System.getProperty("java.class.path");
                String[] classpaths = classpath.split(File.pathSeparator);
                int last_slash = classpaths[0].lastIndexOf("/");
                String sg_path = String.valueOf(classpaths[0].substring(0, last_slash)) + "/plugins/aspectEditor_1.0.0/aspectElements.jar";
                JarFile jf = new JarFile(new File(sg_path));
                Enumeration<JarEntry> enu = jf.entries();
                while (enu.hasMoreElements()) {
                    String entry = ((Object)enu.nextElement()).toString();
                    if (entry.indexOf("class") == -1) continue;
                    entry = entry.replace('/', '.');
                    int last_dot = entry.lastIndexOf(".class");
                    entry = entry.substring(0, last_dot);
                    Class<?> cl = Class.forName(entry);
                    cg.addClass(cl);
                }
            }
            catch (Exception e2) {
                System.out.println("Could not open aspectElements.jar using the Windows or MAC/Solaris/LINUXmethod:");
                System.out.println("\t" + e2 + "\n");
            }
        }
        Enumeration aspectEnumeration = s.get_aspectlanguage_list().elements();
        HashSet<Object> cdNames = new HashSet<Object>();
        while (aspectEnumeration.hasMoreElements()) {
            Object currObj = aspectEnumeration.nextElement();
            String cdType = "aspectEditor.aspectEditorUtils.ClassDictionaryL";
            String traversalType = "aspectEditor.aspectEditorUtils.SelectorL";
            if (cdType.equals(currObj.getClass().getName())) {
                Visitor cdnamev = new Visitor(){
                    Object cdname = new Object();

                    void before(ClassDictionaryName cdName) {
                        this.cdname = cdName.get_ident();
                    }

                    public Object getReturnValue() {
                        return this.cdname;
                    }
                };
                cg.traverse((Object)s, "from * via aspectEditor.aspectEditorUtils.ClassDictionaryL to *", cdnamev);
                Object cdNameHash = cdnamev.getReturnValue();
                cdNames.add(cdNameHash);
                ClassDictionaryL currDict = (ClassDictionaryL)currObj;
                edu.neu.ccs.demeter.aplib.cd.ClassGraph inputcg = edu.neu.ccs.demeter.aplib.cd.ClassGraph.parse((String)currDict.get_classdict().get_text().toString());
                inputcg = inputcg.normalize();
                HashSet usedClasses = new HashSet(inputcg.getNodes());
                Iterator usedIterator = usedClasses.iterator();
                while (usedIterator.hasNext()) {
                    Object currClass = usedIterator.next();
                    if (inputcg.definesClass(currClass.toString())) continue;
                    System.out.println();
                    System.out.println("Semantic Error: The class " + currClass.toString() + " is used, but not defined.");
                    stringOfErrors = String.valueOf(stringOfErrors) + "\nSemantic Error: The class " + currClass.toString() + " is used, but not defined.";
                }
            }
            if (!traversalType.equals(currObj.getClass().getName())) continue;
            SelectorL cfr_ignored_0 = (SelectorL)currObj;
            Visitor selectorv = new Visitor(){
                final HashSet selnamehash = new HashSet();

                void before(SelectorName selectorName) {
                    this.selnamehash.add(selectorName.get_ident());
                }

                public Object getReturnValue() {
                    return this.selnamehash;
                }
            };
            Visitor strategyv = new Visitor(){
                final HashSet stratnamehash = new HashSet();

                void before(StrategyName strategyName) {
                    this.stratnamehash.add(strategyName.get_name());
                }

                public Object getReturnValue() {
                    return this.stratnamehash;
                }
            };
            Visitor subsetnamev = new Visitor(){
                final HashSet subsetnamehash = new HashSet();

                void before(NodeSubsetName subsetName) {
                    this.subsetnamehash.add(subsetName.get_name());
                }

                public Object getReturnValue() {
                    return this.subsetnamehash;
                }
            };
            Visitor subsetnamev2 = new Visitor(){
                final HashSet subsetnamehash = new HashSet();

                void before(NodeSubsetName subsetName) {
                    this.subsetnamehash.add(subsetName.get_name());
                }

                public Object getReturnValue() {
                    return this.subsetnamehash;
                }
            };
            Visitor strategynamev = new Visitor(){
                final HashSet strategynamehash = new HashSet();

                void before(StrategyName strategyName) {
                    this.strategynamehash.add(strategyName.get_name());
                }

                public Object getReturnValue() {
                    return this.strategynamehash;
                }
            };
            cg.traverse((Object)s, "from * to *", selectorv);
            HashSet selNameHash = (HashSet)selectorv.getReturnValue();
            cg.traverse((Object)s, "from * through aspectEditor.aspectEditorUtils.StrategyDef to *", strategyv);
            HashSet stratNameHash = (HashSet)strategyv.getReturnValue();
            cg.traverse((Object)s, "from aspectEditor.aspectEditorUtils.XAspectLanguage2 bypassing aspectEditor.aspectEditorUtils.NodeSubsetExpression to-stop aspectEditor.aspectEditorUtils.NodeSubsetName", subsetnamev);
            HashSet subsetNameHashDecl = (HashSet)subsetnamev.getReturnValue();
            cg.traverse((Object)s, "from * via aspectEditor.aspectEditorUtils.NodeSubsetExpression to *", subsetnamev2);
            HashSet subsetNameHashUsed = (HashSet)subsetnamev2.getReturnValue();
            cg.traverse((Object)s, "from * through aspectEditor.aspectEditorUtils.GraphNodes to *", strategynamev);
            HashSet strategyNameHash = (HashSet)strategynamev.getReturnValue();
            Iterator selectorNameI = selNameHash.iterator();
            while (selectorNameI.hasNext()) {
                Object currSelectorN = selectorNameI.next();
                if (stratNameHash.contains(currSelectorN)) continue;
                System.out.println("Semantic Error: There is not a strategy named (Selector Name Error): " + currSelectorN.toString());
                stringOfErrors = String.valueOf(stringOfErrors) + "\nSemantic Error: There is not a strategy named (Selector Name Error): " + currSelectorN.toString();
            }
            Iterator strategyNameI = strategyNameHash.iterator();
            while (strategyNameI.hasNext()) {
                Object currStrategyN = strategyNameI.next();
                if (stratNameHash.contains(currStrategyN)) continue;
                System.out.println("Semantic Error: There is not a strategy named (Node Set Error): " + currStrategyN.toString());
                stringOfErrors = String.valueOf(stringOfErrors) + "\nSemantic Error: There is not a strategy named (Node Set Error): " + currStrategyN.toString();
            }
            Iterator subsetNameI = subsetNameHashUsed.iterator();
            while (subsetNameI.hasNext()) {
                Object currSubsetN = subsetNameI.next();
                if (subsetNameHashDecl.contains(currSubsetN)) continue;
                System.out.println("Semantic Error: There is not a strategy named (Node Subset Error): " + currSubsetN.toString());
                stringOfErrors = String.valueOf(stringOfErrors) + "\nSemantic Error: There is not a strategy named (Node Subset Error): " + currSubsetN.toString();
            }
            Visitor cdnamev2 = new Visitor(){
                HashSet cdname = new HashSet();

                void before(ClassDictionaryName cdName) {
                    this.cdname.add(cdName.get_ident());
                }

                public Object getReturnValue() {
                    return this.cdname;
                }
            };
            cg.traverse((Object)s, "from * bypassing aspectEditor.aspectEditorUtils.ClassDictionaryL to *", cdnamev2);
            HashSet cdNameHash2 = (HashSet)cdnamev2.getReturnValue();
            Iterator cdNameI = cdNameHash2.iterator();
            while (cdNameI.hasNext()) {
                Object currcdN = cdNameI.next();
                if (cdNames.contains(currcdN)) continue;
                System.out.println("Semantic Error: There is no class dictionary named (chosen class dictionary Error): " + currcdN.toString());
                stringOfErrors = String.valueOf(stringOfErrors) + "\nSemantic Error: There is no class dictionary named (chosen class dictionary Error): " + currcdN.toString();
            }
            stringOfErrors = String.valueOf(stringOfErrors) + "\n\nSemantic Checking Complete.";
            stringOfErrors = String.valueOf(stringOfErrors) + "\n \n \n Please click a traversal aspect line to peform a traversal";
            AspectEditor.traversalViewer.setText(stringOfErrors);
        }
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        this.universal_trv0_aft(_v_);
    }
}

