/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib;

import edu.neu.ccs.demeter.aplib.IncompatibleClassGraphsException;
import edu.neu.ccs.demeter.aplib.Traversal;
import edu.neu.ccs.demeter.aplib.TraversalCombination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TraversalIntersection
extends TraversalCombination {
    public TraversalIntersection(Traversal l, Traversal r) throws IncompatibleClassGraphsException {
        super(l, r);
    }

    public String toString() {
        return "intersection(" + this.left + ", " + this.right + ")";
    }

    protected List combineNodeSetLists(List l, List r) {
        ArrayList<Traversal.NodeSet> x = new ArrayList<Traversal.NodeSet>();
        Iterator li = l.iterator();
        while (li.hasNext()) {
            Traversal.NodeSet ls = (Traversal.NodeSet)li.next();
            Iterator ri = r.iterator();
            while (ri.hasNext()) {
                Traversal.NodeSet rs = (Traversal.NodeSet)ri.next();
                if (!ls.sameNode(rs)) continue;
                x.add(this.combineNodeSets(ls, rs));
            }
        }
        return Collections.unmodifiableList(x);
    }

    protected Traversal.NodeSet combineNodeSets(Traversal.NodeSet l, Traversal.NodeSet r) {
        return l == null || r == null ? null : new NodeSet(l, r);
    }

    protected List combineEdgeSetLists(List l, List r) {
        ArrayList<Traversal.EdgeSet> x = new ArrayList<Traversal.EdgeSet>();
        Iterator li = l.iterator();
        while (li.hasNext()) {
            Traversal.EdgeSet ls = (Traversal.EdgeSet)li.next();
            Iterator ri = r.iterator();
            while (ri.hasNext()) {
                Traversal.EdgeSet rs = (Traversal.EdgeSet)ri.next();
                if (!ls.sameEdge(rs)) continue;
                x.add(this.combineEdgeSets(ls, rs));
            }
        }
        return Collections.unmodifiableList(x);
    }

    protected Traversal.EdgeSet combineEdgeSets(Traversal.EdgeSet l, Traversal.EdgeSet r) {
        return l == null || r == null ? null : new EdgeSet(l, r);
    }

    class EdgeSet
    extends TraversalCombination.EdgeSet {
        EdgeSet(Traversal.EdgeSet l, Traversal.EdgeSet r) {
            super(l, r);
        }

        String indicesToString() {
            return "intersect" + super.indicesToString();
        }
    }

    class NodeSet
    extends TraversalCombination.NodeSet {
        NodeSet(Traversal.NodeSet l, Traversal.NodeSet r) {
            super(l, r);
        }

        String indicesToString() {
            return "intersect" + super.indicesToString();
        }
    }
}

