/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter;

import edu.neu.ccs.demeter.Ident;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Graph {
    private Hashtable graph = new Hashtable();

    public Graph(Hashtable t) {
        this.graph = t;
    }

    public Graph() {
        this.graph = new Hashtable();
    }

    public static Graph fromString(String str) {
        return Graph.fromString(new StreamTokenizer(new StringReader(str)));
    }

    public static Graph fromString(StreamTokenizer instr) {
        instr.lowerCaseMode(false);
        instr.wordChars(95, 95);
        instr.ordinaryChar(46);
        Hashtable<Ident, Object[]> g = new Hashtable<Ident, Object[]>();
        try {
            instr.nextToken();
            while (instr.ttype != 46 && instr.ttype != -1) {
                Ident cn = new Ident(instr.sval);
                instr.nextToken();
                if (instr.ttype != 40) {
                    System.out.println("Confused");
                    System.exit(1);
                }
                instr.nextToken();
                int numparts = (int)instr.nval;
                instr.nextToken();
                Object[] em = new Object[2 * numparts + 1];
                g.put(cn, em);
                int partcount = 1;
                while (instr.ttype != 41) {
                    Ident pn = new Ident(instr.sval);
                    instr.nextToken();
                    Ident pc = new Ident(instr.sval);
                    instr.nextToken();
                    em[2 * partcount - 1] = pn;
                    em[2 * partcount] = pc;
                    ++partcount;
                }
                instr.nextToken();
            }
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        return new Graph(g);
    }

    public String toString() {
        String str = "";
        Enumeration e = this.graph.keys();
        while (e.hasMoreElements()) {
            Ident key = (Ident)e.nextElement();
            str = str + key + " ( ";
            Object[] parts = (Object[])this.graph.get(key);
            int numparts = (parts.length - 1) / 2;
            str = str + numparts + " ";
            int i = 1;
            while (i <= numparts) {
                Ident pn = (Ident)parts[2 * i - 1];
                Ident pc = (Ident)parts[2 * i];
                str = str + pn + " " + pc + " ";
                ++i;
            }
            str = str + " ) ";
        }
        return str + " .";
    }

    public Enumeration nodes() {
        return this.graph.keys();
    }

    public boolean nodeexists(Ident node) {
        return this.graph.containsKey(node);
    }

    public boolean edgeexists(Ident from, Ident name) {
        if (!this.nodeexists(from)) {
            return false;
        }
        Object[] parts = this.edgesfrom(from);
        int numparts = (parts.length - 1) / 2;
        int i = 1;
        while (i <= numparts) {
            if (name.equals((Ident)parts[2 * i - 1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] edgesfrom(Ident node) {
        if (this.nodeexists(node)) {
            return (Object[])this.graph.get(node);
        }
        Object[] e = new Object[1];
        this.graph.put(node, e);
        return e;
    }

    public Object getdestnode(Ident node, Ident edgename) {
        Object[] parts = this.edgesfrom(node);
        int numparts = (parts.length - 1) / 2;
        while (numparts > 0) {
            if ((Ident)parts[numparts * 2 - 1] == edgename) {
                return parts[numparts * 2];
            }
            --numparts;
        }
        return null;
    }

    public void makeedge(Ident from, Ident edgename, Ident to) {
        Object[] parts = this.edgesfrom(from);
        Object[] newparts = new Object[parts.length + 2];
        newparts[0] = parts[0];
        newparts[parts.length] = edgename;
        newparts[parts.length + 1] = to;
        this.graph.put(from, newparts);
        int numparts = (parts.length - 1) / 2;
        while (numparts > 0) {
            if ((Ident)parts[numparts * 2 - 1] == edgename) {
                parts[numparts * 2] = to;
                this.graph.put(from, parts);
                break;
            }
            newparts[numparts * 2 - 1] = parts[numparts * 2 - 1];
            newparts[numparts * 2] = parts[numparts * 2];
            --numparts;
        }
    }

    public void clearnode(Ident from) {
        this.graph.put(from, new Object[1]);
    }

    public void removeincoming(Ident to) {
        Enumeration thenodes = this.nodes();
        while (thenodes.hasMoreElements()) {
            Ident cn = (Ident)thenodes.nextElement();
            Object[] parts = this.edgesfrom(cn);
            if (parts.length < 3) continue;
            Object[] newparts = new Object[parts.length - 2];
            int numparts = (parts.length - 1) / 2;
            int partcount = 1;
            while (partcount < numparts && (Ident)parts[2 * partcount - 1] != to) {
                newparts[partcount] = parts[partcount];
                ++partcount;
            }
            if ((Ident)parts[2 * partcount - 1] != to) continue;
            this.graph.put(cn, newparts);
            while (partcount < numparts) {
                newparts[partcount] = parts[partcount + 2];
                ++partcount;
            }
        }
    }

    public Graph reversegraph() {
        Graph g = new Graph();
        Enumeration thenodes = this.nodes();
        while (thenodes.hasMoreElements()) {
            Ident node = (Ident)thenodes.nextElement();
            Object[] edges = this.edgesfrom(node);
            int numparts = (edges.length - 1) / 2;
            int i = 1;
            while (i <= numparts) {
                Ident edgename = (Ident)edges[2 * i - 1];
                Ident edgeto = (Ident)edges[2 * i];
                edgename = new Ident(edgename.toString() + node.toString());
                g.makeedge(edgeto, edgename, node);
                ++i;
            }
        }
        return g;
    }

    public void marknode(Ident node, String mark) {
        if (this.edgesfrom(node)[0] == null) {
            this.edgesfrom((Ident)node)[0] = new Vector();
        }
        ((Vector)this.edgesfrom(node)[0]).addElement(mark);
    }

    public boolean nodehasmark(Ident node, String mark) {
        return this.edgesfrom(node)[0] != null && ((Vector)this.edgesfrom(node)[0]).contains(mark);
    }

    public void clearmark(String mark) {
        Enumeration thenodes = this.nodes();
        while (thenodes.hasMoreElements()) {
            Ident node = (Ident)thenodes.nextElement();
            if (this.edgesfrom(node)[0] == null) continue;
            ((Vector)this.edgesfrom(node)[0]).removeElement(mark);
        }
    }

    public Graph deepcopy() {
        Graph g = new Graph();
        Enumeration thenodes = this.nodes();
        while (thenodes.hasMoreElements()) {
            Ident node = (Ident)thenodes.nextElement();
            g.graph.put(node, this.edgesfrom(node).clone());
        }
        return g;
    }

    public void dfs(Ident from, String mark) {
        if (this.nodehasmark(from, mark)) {
            return;
        }
        this.marknode(from, mark);
        Object[] edges = this.edgesfrom(from);
        int partcount = 1;
        int numparts = (edges.length - 1) / 2;
        while (partcount <= numparts) {
            this.dfs((Ident)edges[2 * partcount++], mark);
        }
    }
}

