/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package wrap.core;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class at current statage is not thread safe.
 * @author liang
 */
public class CController {

    private java.util.HashMap values;
    private java.util.Map<String, PageContainer> pages;
    private java.util.Stack<String> backlist;
    private CPanel panel;
    private CSound cSound;
    private boolean soundEnabled;
    private Object currentPageObject;

    public CController() {
        values = new java.util.HashMap();
        pages = new java.util.HashMap<String, PageContainer>();
        backlist = new java.util.Stack<String>();
        cSound = new CSound();
    }

    java.util.Map<String, PageContainer> getPages() {
        return pages;
    }

    CPanel getPanel() {
        return panel;
    }

    void setPanel(CPanel panel) {
        this.panel = panel;
    }

    public java.util.HashMap getValues() {
        return values;
    }

    public void to(String page) {
        showPage(page);
        

    }

    public void back() {
        if(backlist.empty()){
            System.out.println("backlist is empty");
            return;
        }
        backlist.pop();
        String page = backlist.pop();
        showPage(page);
        System.out.println("poped " + page);
    }

    void playPageSound() {
        if(currentPageObject == null){
            _playPageSound();
            return;
        }
        try {
            Object o = currentPageObject;
            java.lang.reflect.Method m = o.getClass().getMethod("getSoundName", new Class[0]);
            Object ret = m.invoke(o, new Object[0]);
            String name = ret.toString();
            System.out.println("Now playing reflected: " + name);
            this.cSound.playSound(name);

        } catch (NoSuchMethodException ex) {
            _playPageSound();

        } catch (SecurityException ex) {

            Logger.getLogger(CController.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex);
            _playPageSound();
        } catch (Exception ex) {

            Logger.getLogger(CController.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex);
            _playPageSound();
        }
        //_playPageSound();
    }

    void _playPageSound() {
        this.cSound.playSound(currentPage);
    }

    void stopSound(){
        cSound.stopSound();
    }

    void enableSound(){
        soundEnabled = true;
    }

    void disableSound(){
        soundEnabled = false;
    }


    private String currentPage;
    void showPage(String page) {
        currentPage = page;
        panel.setEnabled(false);
        panel.removeAll();
        PageContainer pc = pages.get(page);
        Object o = pc.newInstance();
        currentPageObject = o;

        if(o == null){
            System.out.println("Null page instance of " + page);
            return;
        }
        if(!(o instanceof Component)){
            System.out.println("Not instance of java.awt.Compoenent, " + page);
            return;
        }

        Component c = (Component) o;
        
        panel.add(c, java.awt.BorderLayout.CENTER);
        panel.validate();
        panel.repaint();
        panel.setEnabled(true);
        panel.requestFocus();

        backlist.push(page);

        if(page != "Start" && page != "Instruction")
            stopSound();

        if(soundEnabled){
            playPageSound();
        }
        System.out.println("push " + page);
    }

}
